/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // insert code to be run when the symbol is created here
         sym.$("cross2").hide();
         sym.$("tick").hide();
         sym.$("tick1").hide();
         sym.$("tick2").hide();

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "${cap}", "click", function(sym, e) {
         
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("cap2")[0].currentTime = 0;
         if (sym.$("cap2")[0].paused) {
         	sym.$("cap2")[0].play();
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${Nerdy_Glasses}", "click", function(sym, e) {
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("sunglasses")[0].currentTime = 0;
         if (sym.$("sunglasses")[0].paused) {
         	sym.$("sunglasses")[0].play();
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${t-shirt1}", "click", function(sym, e) {
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("t_shirt2")[0].currentTime = 0;
         if (sym.$("t_shirt2")[0].paused) {
         	sym.$("t_shirt2")[0].play();
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${refresh2}", "click", function(sym, e) {
         window.location.reload()

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      

      

      Symbol.bindElementAction(compId, symbolName, "${pull}", "click", function(sym, e) {
         // insert code for mouse click here
         // Hide an element 
         
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("pullover")[0].currentTime = 0;
         if (sym.$("pullover")[0].paused) {
         	sym.$("pullover")[0].play();
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${EllipseCopy}", "click", function(sym, e) {
         sym.$("tick1").hide();
         sym.$("tick2").hide();
         sym.$("tick").hide();
         
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("Wrong_Buzzer")[0].currentTime = 0;
         if (sym.$("Wrong_Buzzer")[0].paused) {
         	sym.$("Wrong_Buzzer")[0].play();
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${Ellipse}", "click", function(sym, e) {
         sym.$("tick").show();
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("correct_sound")[0].currentTime = 0;
         if (sym.$("correct_sound")[0].paused) {
         	sym.$("correct_sound")[0].play();
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${EllipseCopy2}", "click", function(sym, e) {
         sym.$("tick1").show();
         
         sym.$("correct_sound")[0].currentTime = 0;
         if (sym.$("correct_sound")[0].paused) {
         	sym.$("correct_sound")[0].play();
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${EllipseCopy3}", "click", function(sym, e) {
         sym.$("tick2").show();
         
         sym.$("correct_sound")[0].currentTime = 0;
         if (sym.$("correct_sound")[0].paused) {
         	sym.$("correct_sound")[0].play();
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-9288897");